const GroupLocalServiceUtil = Packages.com.liferay.portal.service.GroupLocalServiceUtil();
const PortletBeanLocatorUtil = Packages.com.liferay.portal.kernel.bean.PortletBeanLocatorUtil();
const UserLocalServiceUtil = Packages.com.liferay.portal.service.UserLocalServiceUtil();
const LayoutServiceUtil = Packages.com.liferay.portal.service.LayoutServiceUtil();
const LayoutLocalServiceUtil = Packages.com.liferay.portal.service.LayoutLocalServiceUtil();
const PortletPreferencesLocalServiceUtil = com.liferay.portal.service.PortletPreferencesLocalServiceUtil();
const PortalUtil = Packages.com.liferay.portal.util.PortalUtil();
const GroupConstants = Packages.com.liferay.portal.model.GroupConstants();
const LayoutConstants = Packages.com.liferay.portal.model.LayoutConstants();
const PortletKeys = Packages.com.liferay.portal.util.PortletKeys();
const DLAppServiceUtil = Packages.com.liferay.portlet.documentlibrary.service.DLAppServiceUtil();
const DLFileEntryLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil();
const DLFolderLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil();
const AssetCategoryLocalServiceUtil = com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil();
const AssetEntryLocalServiceUtil = com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil();
const JournalFolderLocalServiceUtil = com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil();
const JournalArticleLocalServiceUtil = com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil();
const ddlRecordLocalServiceUtil = Packages.com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil();
const ddlRecordSetLocalServiceUtil = Packages.com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil();
const OrganizationLocalServiceUtil = Packages.com.liferay.portal.service.OrganizationLocalServiceUtil();

const WebContentService = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'webContentService' );
const PageLeadAdapter = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'pageLeadAdapter' );
const ContentBodyAdapter = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'contentBodyAdapter' );
const PageSectionAdapter = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'pageSectionAdapter' );

const defaultCompanyId = PortalUtil.getDefaultCompanyId();
const adminUser = UserLocalServiceUtil.getUserByScreenName(defaultCompanyId, "padmin");
const serviceContext = Packages.com.liferay.portal.service.ServiceContext();
const defaultParentLayoutId = LayoutConstants.DEFAULT_PARENT_LAYOUT_ID;
const defaultLayoutTemplate = '1_column_12';
const adtPortletSuffix = '_WAR_empointadtviewer';
const contentPortletSuffix = '_WAR_empointcontentviewer';
const defaultLocale = Packages.com.liferay.portal.kernel.util.LocaleUtil.getDefault();

const likelihoods = 
{
"Rare":"1",
"Unlikely":"2",
"Possible":"3",
"Likely":"4",
"Almost certain":"5"
};

const consequences = 
{
"Insignificant":"1",
"Minor":"2",
"Moderate":"3",
"Major":"4",
"Catastrophic":"5"
};

const hazardTypes = 
{
"Bushfire":"bushfire",
"Flood":"flood",
"Heatwave":"heatwave",
"Public Health Incident":"public-health",
"Public Safety Incident":"public-safety",
"Storm":"storm",
"Structural Fire":"structural-fire",
"Dam Failure":"dam-failure",
"Landslide":"landslide",
"Earthquake":"earthquake",
"Tsunami":"tsunami",
"Other":"other"
};

const data = 

{"id":"AllSeasons","email":"info@allseasonscaravanpark.com.au","caravan_park_name":"All Seasons Holiday Park","business_landline_phone":"03 50233375","mobile_phone":"0400088483","fax":"03 50214537","owner_name":"Jodie Bromley","manager_name":"Jodie Bromley","nr_permanent_residents":"20.0","nr_sites":"63.0","postal_address":"P.O. Box 4068 Mildura 3502","street_address":"818 Fifteenth St Mildura 3500","evacuation_plan_description":"In the case of emergency, a horn will sound, please make your way to the nearest Fire Assembly Area (Primary \u003d Main gate Secondary \u003d Tennis Court) Stage 1 Secure your valuables if safe to do so. Turn off power \u0026 gas to your site/room Close all windows and doors. Gather your family \u0026 persons nearby Stage 2 Alert management immediately, call 000 Stage 3 Contain the emergency where possible and only if safe to do so Stage 4 Evacuate. Close doors behind you. Follow Fire Wardens instructions. Meet at assembly Points","site_map_description":"2.12Ha located on 15th St, Calder Hwy, Mildura Facilities incl: swimming pool, playground, jumping pillow, BBQ gazebo Amenities block, camp kitchen, TV/Games room Guests incl: visiting family and friends, grey nomads in vans and seasonal workers Busy periods are March - Nov Proposed alteration to above plan is the relocation of old cabins to the east boundary as per planning permit and making new caravan sites in the park out of the old cabin positions","council_name":"Mildura City Council","council_phone":"5018 8100","emergency_electrician_name":"Sean Bromley","emergency_electrician_phone":"0408 958 290","emergency_plumber_name":"Leonards Plumbing","emergency_plumber_phone":"5023 0535","fire_authority_name":"Mildura","fire_authority_phone":"5051 4130","insurance_name":"Grampians Insurance","insurance_policy_number":"144A915364BPK","insurance_policy_phone":"1300 292 041","medical_services_name":"Mildura Base Hospital","medical_services_phone":"5022 3333","police_station_name":"Mildura Police","police_phone":"5018 5300","water_authority_name":"L.M.W.A","water_authority_phone":"5051 3400","hazards":{"":{"hazard":"","likelihood":"Almost certain","consequence":"Moderate","beforeMap":{"1":{"action":"check air conditioners are in good working order","who":"staff / Devillees","how":"regular service"},"2":{"action":"notify customers on blackboard about expected temperatures","who":"office staff","how":"write upi and place out front of office"},"3":{"action":"stock up on water","who":"staff","how":"order in"}},"duringMap":{"1":{"action":"recommend customer\u0027s move to cooler locations (movies / shopping centres)","who":"office staff","how":"write up on blackboard options alert customers and residents of daily optimum temp"},"2":{"action":"keep supply of cook water available","who":"office staff","how":"stock fridge"},"3":{"action":"Check on older residents in park","who":"Staff","how":"call or visit to check OK"},"4":{"action":"darken the accommodation, keep heat out keep doors closed and blinds down","who":"residents, customers and staff","how":"lower blinds close doors"},"5":{"action":"cancel outdoor activities not required","who":"staff","how":"write up on blackboard"},"6":{"action":"stay indoors be less active","who":"individuals","how":"cancel activities"}},"afterMap":{"1":{"action":"check on residents and guests in the park","who":"individuals, other guests and staff","how":"call or knock on doors"},"2":{"action":"if any A/c didn\u0027t work optimally, organise to be serviced","who":"staff / maintenance","how":"call Devilless"},"3":{"action":"review actions prior and during heatwave to determine if best outcome was achieved","who":"staff","how":"review actions and outcomes"}},"incidentMap":{}},"Storm":{"hazard":"Storm","likelihood":"Possible","consequence":"Minor","beforeMap":{"1":{"action":"check Bureaus meteorology","who":"staff","how":"internet"},"2":{"action":"lock up sheds and put away all equipment","who":"staff","how":"collect and store"},"3":{"action":"notify patrols","who":"staff","how":"write up on blackboard go around to patrons"},"4":{"action":"ensure all caravans tied down","who":"individual\u0027s","how":"recommend to owners"}},"duringMap":{"1":{"action":"Ensure all patrons stay in doors","who":"staff","how":"recommend and verbally advise"},"2":{"action":"keep patrons away from drains/gutters","who":"staff","how":"advise"}},"afterMap":{"1":{"action":"check park for damage and hazards","who":"staff","how":"walk around and collect cut down"},"2":{"action":"ensure no one plays in pools of storm water or in areas that are damaged from the storm,","who":"staff","how":"close off"},"3":{"action":"call SES is serious damage","who":"staff","how":""},"4":{"action":"close off park areas that are damaged by storm","who":"staff","how":"walk around and cordon off"}},"incidentMap":{}},"Structural Fire":{"hazard":"Structural Fire","likelihood":"Possible","consequence":"Major","beforeMap":{},"duringMap":{"1":{"action":"Alert all persons nearby and request assistance.","who":"first person on scene staff","how":"call out to everyone"},"2":{"action":"Assist any person in immediate danger (only if safe to do so).","who":"any body","how":"if safe to do so,"},"3":{"action":"Call the Fire Brigade on â  000â   and notify the caravan park manager if not present","who":"anybody","how":"call 000"},"4":{"action":"Close the door on the fire to contain the spread (only if safe to do so).","who":"anybody","how":"close the door"},"5":{"action":"Turn off all electricity (only if safe to do so). Shut off gas cylinders (only if safe to do so).","who":"staff","how":"go to main switch board and pull fuses turn off gas cylinder\u0027s"},"6":{"action":"Extinguish the fire (only if safe to do so). Check that all areas have been cleared.","who":"staff","how":"fire extinguisher\u0027s / fire blankets / hoses fire warden"},"7":{"action":"Control the movement of occupants to the emergency assembly area or evacuation point. Maintain control of persons at the emergency assembly area or evacuation point.","who":"staff","how":"head everyone to the front gate and to the exit behind tennis crt if safe to do so and away from the fire"}},"afterMap":{"1":{"action":"Do not enter or allow others to enter any buildings that have been damaged by fire","who":"staff CFA","how":"cordon area off"},"2":{"action":"Check your guest register and ensure all residents are accounted for","who":"staff","how":"go around the park knocking on doors and ticking off from computer registry"},"3":{"action":"Call Insurance","who":"Staff","how":"Check Policy"},"4":{"action":"review EMP following incident review strategy / out come and responses","who":"","how":""}},"incidentMap":{}},"Public Health Incident":{"hazard":"Public Health Incident","likelihood":"Rare","consequence":"Insignificant","beforeMap":{},"duringMap":{},"afterMap":{},"incidentMap":{"1":{"incident":"Swimming pool contamination","before":"regular inspect / clean and test and record","during":"evacuate everyone from the pool","after":"place signage up"},"2":{"incident":"Sewerage plumbing issues","before":"regular maintenance of pipes as required","during":"call emergency Plumber notify affected accommodation / sites","after":"Record note of affected area"},"3":{"incident":"Vehicle Incident","before":"speed signs installed","during":"Notify police or /and ambulance","after":"keep onlookers away begin first aid if necessary"},"4":{"incident":"Civil disturbance","before":"","during":"Notify security and police restrict entry isolate fro other occupants","after":""}}},"Public Safety Incident":{"hazard":"Public Safety Incident","likelihood":"Possible","consequence":"Moderate","beforeMap":{},"duringMap":{},"afterMap":{},"incidentMap":{"1":{"incident":"Vehicle Incident","before":"Install speed signs around park","during":"slow all traffic call emergency services","after":"Install speed humps where probable"},"2":{"incident":"Gas Leak","before":"maintain gas bottles","during":"call gas authority disconnect gas bottle","after":"set up scheduled maintenance with gas supplier"}}}},"emergencyActions":[{"question":"Regularly check long range weather forecasts.","answer":"true"},{"question":"Display daily weather information including any warnings in a prominent position in your park.","answer":"true"},{"question":"Ensure staff-members are aware of your EMP and understand their responsibilities in an emergency.","answer":"true"},{"question":"Display an up to date evacuation map and procedure in office, amenities blocks and all park owned dwellings.","answer":"true"},{"question":"Schedule and practise evacuation procedures.","answer":"true"},{"question":"Install and regularly check fire alarms in all park owned dwellings and public areas.","answer":"true"},{"question":"Maintain fire vehicle access.","answer":"true"},{"question":"Maintain fire safety equipment.","answer":"true"},{"question":"Monitor and maintain gas storage and other flammable chemicals.","answer":"true"},{"question":"Prepare an emergency kit which includes a battery powered radio, spare batteries, a torch, first aid kit and a copy of your EMP (this plan).","answer":"true"},{"question":"Check currency and relevance of insurance.","answer":"true"},{"question":"Ensure permanent outdoor furniture is secured or can be easily secured in the event of a storm.","answer":"true"},{"question":"Monitor trees for dangerous branches and remove when necessary.","answer":"true"},{"question":"Regularly clean gutters, downpipes and drains for blockages.","answer":"true"},{"question":"Keep an up to date residents and guest list to be used in the case of evacuations.","answer":"true"},{"question":"Ensure movable vans are maintained in a movable state.","answer":"true"},{"question":"Develop arrangements for emergency warnings to be communicated to occupants (PA system/ door knocking/ public notices).","answer":"true"},{"question":"Provide information for caravan park occupiers and visitors on safety procedures and considerations as well as warning systems at your caravan park.","answer":"true"}],"emergencyBroadcasters":["Mildura: ABC Local 104.3 FM"]}

;

var parkName = data.caravan_park_name;

var org = OrganizationLocalServiceUtil.getOrganization(defaultCompanyId, parkName);
var organizationId = org.getOrganizationId();
var group = GroupLocalServiceUtil.getOrganizationGroup(defaultCompanyId, organizationId);
out.println(group);

var planId;
var userId;
var checklistRsetId;
var hazardRsetId;
var contactRsetId;
var groupId = group.getGroupId();

var rsets = ddlRecordSetLocalServiceUtil.getRecordSets(groupId).toArray();
for (var rs in rsets) {
  if (rsets[rs].getRecordSetKey() == "EP_EMERGENCY_PLAN") {
    var recs = rsets[rs].getRecords().toArray();
    for (var r in recs) {
      planId = recs[r].getRecordId();
      userId = recs[r].getUserId();	  
    }
  }
}

try {
UserLocalServiceUtil.updatePassword(userId, "Changeme2016", "Changeme2016", false);
}
catch (e) {
}

if (planId) {
  for (var rs in rsets) {
    if (rsets[rs].getRecordSetKey() == "EP_HAZARD") {
      hazardRsetId = rsets[rs].getRecordSetId();  
	  clearRecords(rsets[rs]);
    }
    if (rsets[rs].getRecordSetKey() == "EP_CHECKLIST") {
      checklistRsetId = rsets[rs].getRecordSetId();
	  clearRecords(rsets[rs]);
    }
    if (rsets[rs].getRecordSetKey() == "EP_EMERGENCY_CONTACT") {
      contactRsetId = rsets[rs].getRecordSetId();  
	  clearRecords(rsets[rs]);
    }
  }
}

function clearRecords(rset) {
  var recs = rset.getRecords().toArray();
  for (var r in recs) {
    ddlRecordLocalServiceUtil.deleteDDLRecord(recs[r].getRecordId());
  }
}

serviceContext.setScopeGroupId(groupId);
serviceContext.setUserId(userId);

  var policeFields = contactsFieldsMap(guid(), "police", data.police_station_name+"", data.police_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, policeFields, serviceContext);

  var medical1Fields = contactsFieldsMap(guid(), "medical", data.medical_services_name+"", data.medical_services_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, medical1Fields, serviceContext);

  var medical2Fields = contactsFieldsMap(guid(), "medical", data.medical_services_two_name+"", data.medical_services_two_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, medical2Fields, serviceContext);

  var fireAuthorityFields = contactsFieldsMap(guid(), "cfa", data.fire_authority_name+"", data.fire_authority_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, fireAuthorityFields, serviceContext);

  var councilFields = contactsFieldsMap(guid(), "local-council", data.council_name+"", data.council_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, councilFields, serviceContext);

  var electricityAuthorityFields = contactsFieldsMap(guid(), "electrical-authority", data.electricity_authority_name+"", data.electricity_authority_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, electricityAuthorityFields, serviceContext);

  var gasAuthorityFields = contactsFieldsMap(guid(), "gas-authority", data.gas_authority_name+"", data.gas_authority_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, gasAuthorityFields, serviceContext);

  var emergencyElectricianFields = contactsFieldsMap(guid(), "electrician", data.emergency_electrician_name+"", data.emergency_electrician_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, emergencyElectricianFields, serviceContext);

  var emergencyPlumberFields = contactsFieldsMap(guid(), "plumber", data.emergency_plumber_name+"", data.emergency_plumber_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, emergencyPlumberFields, serviceContext);

  var insuranceFields = contactsFieldsMap(guid(), "insurance", data.insurance_name+"", data.insurance_policy_phone+"", data.insurance_policy_number+"");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, insuranceFields, serviceContext);

  var waterAuthorityFields = contactsFieldsMap(guid(), "water-authority", data.water_authority_name+"", data.water_authority_phone+"", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, waterAuthorityFields, serviceContext);

  
for (var b in data.emergencyBroadcasters) {
  out.println(data.emergencyBroadcasters[b]);
  var broadcasterFields = contactsFieldsMap(guid(), "emergency-broadcaster", data.emergencyBroadcasters[b]+"", "", "");
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, contactRsetId, 0, broadcasterFields, serviceContext);
}

var checklistFields = checklistFieldsMap(guid(), JSON.stringify(data.emergencyActions));
ddlRecordLocalServiceUtil.addRecord(userId, groupId, checklistRsetId, 0, checklistFields, serviceContext);

var hazards = data.hazards;
for (var h in hazards) {
  var hazard = hazards[h];
  
  if (hazard.hazard && hazard.hazard.length > 0) {
  
  out.println(h + " " + hazard);
  
  var score = likelihoods[hazard.likelihood] + consequences[hazard.consequence];
  var type;
  var name;
  var hazardType;
  var actions = {};
  
  if (hazard.hazard == "Public Safety Incident" || hazard.hazard == "Public Health Incident") {
    type = "public";
	name = hazard.hazard;
	hazardType = hazardTypes[name];
    actions.action = {};
	actions.action.actions = [];
	
	for (var b in hazard.incidentMap) {
	  var entry = {};
	  entry.incident = hazard.incidentMap[b].incident;
	  entry.before = hazard.incidentMap[b].before;
	  entry.during = hazard.incidentMap[b].during;
	  entry.after = hazard.incidentMap[b].after;
	  actions.action.actions.push(entry);
	}
  }
  else if (hazard.hazard.indexOf("Other: ") > -1) {
    type = "custom";
	name = hazard.hazard.replace("Other: ", "");
	hazardType = hazardTypes["Other"];
    actions.before = {};
    actions.during = {};
    actions.after = {};
	
	actions.before.actions = [];
	actions.during.actions = [];
	actions.after.actions = [];
	
	for (var b in hazard.beforeMap) {
	  var entry = {};
	  entry.action = hazard.beforeMap[b].action;
	  entry.how = hazard.beforeMap[b].how;
	  entry.who = hazard.beforeMap[b].who;
	  actions.before.actions.push(entry);
	}
	
	for (var b in hazard.duringMap) {
	  var entry = {};
	  entry.action = hazard.duringMap[b].action;
	  entry.how = hazard.duringMap[b].how;
	  entry.who = hazard.duringMap[b].who;
	  actions.during.actions.push(entry);
	}
	
	for (var b in hazard.afterMap) {
	  var entry = {};
	  entry.action = hazard.afterMap[b].action;
	  entry.how = hazard.afterMap[b].how;
	  entry.who = hazard.afterMap[b].who;
	  actions.after.actions.push(entry);
	}
  }
  else {
    type = "natural";
	name = hazard.hazard;
	hazardType = hazardTypes[name];
    actions.before = {};
    actions.during = {};
    actions.after = {};
	
	actions.before.actions = [];
	actions.during.actions = [];
	actions.after.actions = [];
	
	for (var b in hazard.beforeMap) {
	  var entry = {};
	  entry.action = hazard.beforeMap[b].action;
	  entry.how = hazard.beforeMap[b].how;
	  entry.who = hazard.beforeMap[b].who;
	  actions.before.actions.push(entry);
	}
	
	for (var b in hazard.duringMap) {
	  var entry = {};
	  entry.action = hazard.duringMap[b].action;
	  entry.how = hazard.duringMap[b].how;
	  entry.who = hazard.duringMap[b].who;
	  actions.during.actions.push(entry);
	}
	
	for (var b in hazard.afterMap) {
	  var entry = {};
	  entry.action = hazard.afterMap[b].action;
	  entry.how = hazard.afterMap[b].how;
	  entry.who = hazard.afterMap[b].who;
	  actions.after.actions.push(entry);
	}
  }
  
  var hazardFields = hazardFieldsMap(guid(), type, hazardType, name, likelihoods[hazard.likelihood], consequences[hazard.consequence], score, JSON.stringify(actions));
  ddlRecordLocalServiceUtil.addRecord(userId, groupId, hazardRsetId, 0, hazardFields, serviceContext);
  }
}

function checklistFieldsMap(id, checklist) {
  var fieldsMap = new java.util.HashMap();
  fieldsMap.put("id", id);
  fieldsMap.put("request", "MIGRATION");
  fieldsMap.put("type", "before-an-emergency");
  fieldsMap.put("source-url", "https://www2.ses.vic.gov.au/get-ready/caravan-park/planning/checklist");
  fieldsMap.put("csrf-token", "-");
  fieldsMap.put("user", userId+"");
  fieldsMap.put("plan", planId+"");
  fieldsMap.put("checklist", checklist);
  fieldsMap.put("_fieldsDisplay", "id_INSTANCE_gevx,request_INSTANCE_zlsq,user_INSTANCE_ttmd,user-name_INSTANCE_spcf,user-phone_INSTANCE_nwwy,user-email_INSTANCE_yywx,source-url_INSTANCE_unab,csrf-token_INSTANCE_seze,target_INSTANCE_bjpb,recaptcha_INSTANCE_rrcu,type_INSTANCE_dmvy,plan_INSTANCE_qiod,checklist_INSTANCE_zpww");
  
  return fieldsMap;
}

function hazardFieldsMap(id, type, hazardType, name, likelihood, consequences, riskScore, actions) {
  var fieldsMap = new java.util.HashMap();
  fieldsMap.put("id", id);
  fieldsMap.put("request", "MIGRATION");
  fieldsMap.put("risk-score", riskScore);
  fieldsMap.put("type", '[' + type + ']');
  fieldsMap.put("source-url", "https://www2.ses.vic.gov.au/get-ready/caravan-park/planning/action-plan?hazard-id=1011361&action-type=during");
  fieldsMap.put("hazard-type", '[' + hazardType + ']');
  fieldsMap.put("likelihood", '[' + likelihood + ']');
  fieldsMap.put("hazard", name);
  fieldsMap.put("csrf-token", "-");
  fieldsMap.put("consequences", '[' + consequences + ']');
  fieldsMap.put("user", userId+"");
  fieldsMap.put("plan", planId+"");
  fieldsMap.put("actions", actions);
  fieldsMap.put("_fieldsDisplay", "id_INSTANCE_ljge,request_INSTANCE_jmkz,user_INSTANCE_iigd,user-name_INSTANCE_gdlk,user-phone_INSTANCE_rrms,user-email_INSTANCE_gxth,source-url_INSTANCE_vjvk,csrf-token_INSTANCE_eaan,target_INSTANCE_joli,recaptcha_INSTANCE_lxov,type_INSTANCE_lgrp,plan_INSTANCE_zpqu,hazard_INSTANCE_csuv,hazard-type_INSTANCE_dkic,likelihood_INSTANCE_evbn,consequences_INSTANCE_xzfh,risk-score_INSTANCE_onls,actions_INSTANCE_lbvx");
  
  return fieldsMap;
}

function contactsFieldsMap(id, type, name, number, other) {
  var fieldsMap = new java.util.HashMap();
  fieldsMap.put("id", id);
  fieldsMap.put("request", "MIGRATION");
  fieldsMap.put("type", '[' + type + ']');
  fieldsMap.put("name", cleanString(name+""));
  fieldsMap.put("number", cleanString(number+""));
  fieldsMap.put("other", cleanString(other+""));
  fieldsMap.put("source-url", "https://www2.ses.vic.gov.au/get-ready/caravan-park/planning/emergency-contacts");
  fieldsMap.put("csrf-token", "-");
  fieldsMap.put("user", userId+"");
//  fieldsMap.put("plan", planId+"");
  fieldsMap.put("_fieldsDisplay", "id_INSTANCE_czib,request_INSTANCE_vezi,user_INSTANCE_wnin,user-name_INSTANCE_rjlv,user-phone_INSTANCE_ccse,user-email_INSTANCE_gmzy,source-url_INSTANCE_tjdh,csrf-token_INSTANCE_meen,target_INSTANCE_xled,recaptcha_INSTANCE_errc,name_INSTANCE_cvie,type_INSTANCE_gogk,number_INSTANCE_gcjr,other_INSTANCE_nqtu");
  
  return fieldsMap;
}

function cleanString(str) {
  return str.replace("undefined", "");
}
 
function guid() {
  function s4() {
    return Math.floor((1 + Math.random()) * 0x10000)
      .toString(16)
      .substring(1);
  }
  return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
    s4() + '-' + s4() + s4() + s4();
}